#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/lll/header.h"
extern u8 _lll_segment_ESegmentRomStart[];
extern u8 _lll_segment_ESegmentRomEnd[];

const LevelScript level_lll_entry[] = {
INIT_LEVEL(),
LOAD_RAW(0x0E, _lll_segment_ESegmentRomStart, _lll_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _bitfs_skybox_mio0SegmentRomStart, _bitfs_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group2_mio0SegmentRomStart, _group2_mio0SegmentRomEnd),
LOAD_RAW(12, _group2_geoSegmentRomStart, _group2_geoSegmentRomEnd),
LOAD_MIO0(6, _group17_mio0SegmentRomStart, _group17_mio0SegmentRomEnd),
LOAD_RAW(13, _group17_geoSegmentRomStart, _group17_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
// LOAD_MODEL_FROM_GEO(226, 0x07007070),
// LOAD_MODEL_FROM_GEO(227, 0x07008dc0),
// LOAD_MODEL_FROM_GEO(228, 0x0700a090),
// LOAD_MODEL_FROM_GEO(229, 0x0700bfe0),
// LOAD_MODEL_FROM_GEO(230, 0x0700e3d0),
// LOAD_MODEL_FROM_GEO(231, 0x0700efd0),
// LOAD_MODEL_FROM_GEO(232, 0x07010780),
// LOAD_MODEL_FROM_GEO(233, 0x07011ab0),
// LOAD_MODEL_FROM_GEO(249, 0x07004a10),
// LOAD_MODEL_FROM_GEO(250, 0x07002a20),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_3),
JUMP_LINK(script_func_global_18),
JUMP_LINK(local_area_lll_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_lll_1_[] = {
AREA(1, Geo_lll_1_0x1543240),
TERRAIN(col_lll_1_0xe01b710),
SET_BACKGROUND_MUSIC(0, 46),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_lll_1_),
JUMP_LINK(local_warps_lll_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_lll_1_[] = {
OBJECT_WITH_ACTS(0, -1200, 1324, 6175, 0, 90, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(122, 0, 3800, 1500, 0, 0, 0, 0x0,  bhvStar, 31),
OBJECT_WITH_ACTS(122, -6500, 100, 500, 0, 0, 0, 0x1000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 1500, 800, -5350, 0, 0, 0, 0x2000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(122, -6000, 2050, -1000, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 3150, 600, -1650, 0, 0, 0, 0x4000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(87, 5000, 3500, 5500, 0, 0, 0, 0x5000000,  bhvBigBully, 31),
OBJECT_WITH_ACTS(201, 1736, 2001, 1501, 0, 0, 0, 0x0,  bhvCannonClosed, 31),
OBJECT_WITH_ACTS(195, -3816, 1300, -1969, 0, 0, 0, 0x0,  bhvBobombBuddyOpensCannon, 31),
OBJECT_WITH_ACTS(137, 1603, 2300, 921, 0, 0, 0, 0x0,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 5000, 500, -5350, 0, 0, 0, 0x0,  bhvExclamationBox, 48),
OBJECT_WITH_ACTS(228, -6050, -10, 6150, 0, 0, 0, 0x0,  Bhv_Custom_0x13005740, 31),
OBJECT_WITH_ACTS(228, -6000, 0, 500, 0, 0, 0, 0x0,  Bhv_Custom_0x13005740, 31),
OBJECT_WITH_ACTS(228, 2700, -10, 6150, 0, 0, 0, 0x0,  Bhv_Custom_0x13005740, 31),
OBJECT_WITH_ACTS(232, 5000, 30, 5500, 0, 0, 0, 0x6000000,  Bhv_Custom_0x130057d8, 31),
OBJECT_WITH_ACTS(227, 4750, -75, 3650, 0, -90, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, 5250, -75, 3000, 0, -90, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(233, 5000, -175, -1000, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(233, 5000, -175, -2250, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(233, 4300, -175, -1625, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(233, -2076, 750, -1647, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(233, -3476, 1250, -461, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(233, -3815, 1550, 480, 0, 0, 0, 0x0,  Bhv_Custom_0x13005804, 31),
OBJECT_WITH_ACTS(230, -6767, 850, -1952, 0, 0, 0, 0x0,  Bhv_Custom_0x13005774, 31),
OBJECT_WITH_ACTS(229, -6093, 0, -3739, 0, 60, 0, 0x0,  Bhv_Custom_0x1300583c, 31),
OBJECT_WITH_ACTS(227, -5000, -100, -4800, 0, 0, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -4200, -100, -5700, 0, 0, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -3300, -100, -5100, 0, 0, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -2400, -100, -5300, 0, 0, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -1500, -100, -5600, 0, 0, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(231, 0, 0, 6200, 0, 90, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -5565, 0, 3859, 0, 25, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -6580, 0, 3435, 0, 330, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -4781, 0, 2904, 0, 62, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -6842, 0, 1933, 0, 50, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -5224, 0, 1432, 0, 112, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(231, -5767, 0, 2506, 0, 168, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(0, -3450, 200, 4517, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 4988, 200, 5494, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 6551, 200, 532, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 6490, 200, -6183, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 1929, 200, -3255, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(215, 0, 150, 6175, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 6050, 150, 5500, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1500, 150, -5350, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -1614, 150, -3478, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3500, 500, -1600, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, -3815, 1900, 480, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 1600, 2050, 2100, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4300, 200, -1600, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(227, -2700, -100, -4100, 0, 90, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -4000, -100, -3600, 0, 90, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(227, -1600, -100, -3500, 0, 90, 0, 0x0,  Bhv_Custom_0x13005874, 31),
OBJECT_WITH_ACTS(86, -4425, 200, 6150, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(86, 1000, 300, 6350, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(86, 1350, 300, 5950, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(86, 4967, 200, 2083, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(0, -3750, 0, 6150, 0, 0, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, 5000, 0, 1500, 0, 0, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, 5000, 0, -4800, 0, 0, 0, 0x40000,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, -3500, 1300, -1650, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(0, 5000, 200, -5350, 0, 0, 0, 0x0,  bhvMrI, 31),
OBJECT_WITH_ACTS(180, 3150, 400, -1650, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, -6000, 100, 6150, 0, 90, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2750, 100, 6150, 0, 90, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5000, 500, -3750, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5000, 500, 500, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 400, 700, -1600, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -2250, 2300, 1500, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -6100, 275, -3750, 0, 150, 0, 0x100000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -4000, 200, -3550, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(231, 1450, 0, -5350, 0, 0, 0, 0x0,  Bhv_Custom_0x130057a8, 31),
OBJECT_WITH_ACTS(0, 1500, 550, -5350, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(86, 2900, 300, -1350, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(86, 3350, 300, -1850, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(180, -2076, 1200, -1647, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, -3476, 1700, -461, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(0, -5700, 100, 500, 0, 0, 0, 0x120000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(140, -6500, 200, 4785, 0, 0, 0, 0x0,  bhvBlueCoinSwitch, 31),
OBJECT_WITH_ACTS(118, -5550, 150, 3825, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -6550, 150, 3450, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -4800, 150, 2850, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5800, 150, 2525, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -6850, 150, 1900, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(118, -5250, 150, 1400, 0, 0, 0, 0x0,  bhvHiddenBlueCoin, 31),
OBJECT_WITH_ACTS(86, 3082, 330, -5175, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(86, -299, 275, -5535, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(180, -800, 300, -5350, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 3800, 300, -5350, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(86, -216, 664, -1641, 0, 0, 0, 0x0,  bhvSmallBully, 31),
OBJECT_WITH_ACTS(0, 1200, 300, 6175, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, -2700, 350, 6150, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(202, 3717, 250, 2101, 0, 0, 0, 0x0,  bhvCheckerboardElevatorGroup, 31),
OBJECT_WITH_ACTS(230, 3024, 850, 2204, 0, 0, 0, 0x0,  Bhv_Custom_0x13005774, 31),
OBJECT_WITH_ACTS(230, 2665, 1350, 1301, 0, 0, 0, 0x0,  Bhv_Custom_0x13005774, 31),
OBJECT_WITH_ACTS(124, -1189, 300, 5635, 0, 0, 0, 0x420000,  bhvMessagePanel, 31),
OBJECT_WITH_ACTS(0, -5, 4, 608, 0, 0, 20, 1,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_lll_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 2, 41, 0),
WARP_NODE(241, 6, 2, 51, 0),
RETURN()
};
